#include <avr/interrupt.h>    
#include <avr/io.h>  

#include <SPI.h>
#include <DAC.h>
#include <LED_debug.h>

#define ON  HIGH
#define OFF LOW

// DAC demo program for an NB2AS.
// The DAC is a TI TLV5618 with a 1.225V reference.

// the chip select pin is attached to pin 5 (PB4)

#define DAC_CS_PIN     4  //PB4
#define SPI_TIMEOUT    10 // mS

LED_debug led(15);

//
//

SPI spi = SPI(SPI_TIMEOUT, NB2AS_MOSI_PIN, NB2AS_MISO_PIN, NB2AS_SCK_PIN);
DAC_TLV5618 dac  = DAC_TLV5618(DAC_CS_PIN);

void setup() {

  Serial.begin(19200); 

  // Setup the SPI control register (SPCR)
  // and the status register (SPSR)

  // Page 169 ATmega644P Datasheet Rev 8011L-AVR-02/09

  // SPIE = 0  =0 SPI INT disabled,   =1 enabled
  // SPE  = 1  =0 SPI disabled,       =1 enabled     
  // DORD = 0  =0 MSB First,          =1 LSB First
  // MSTR = 1  =0 Slave,              =1 Master mode
  // CPOL = 1  =0 SCK high when idle, =1 SCK low when idle,
  // CPHA = 1  =0 Sample on leading edge, =1 falling edge
  // SPR1, SPR2 = 0 fosc/4 (= 1 fosc/16)
  //                       (= 2 fosc/64)
  //                       (= 3 fosc/128)

  // SPSR is read only except for the double speed bit

  // SPI2X = 1 double speed

  spi.init(((1<<SPE) | (1<<MSTR) | (0<<CPHA) | (1<<CPOL)), (1<<SPI2X));

}

void loop() {

  // DACA is U21 pin 4
  // DACB is U21 pin 7
  
  
  while(1) {
    dac.set_voltage(DAC_WRITE_B_AND_BUFFER, 1);
    dac.set_voltage(DAC_WRITE_A_UPDATE_B, 1.75);
    delay(100);
    dac.set_voltage(DAC_WRITE_B_AND_BUFFER, 0.5);
    dac.set_voltage(DAC_WRITE_A_UPDATE_B, 0.875);
    delay(100);
    led.blink(2);
  }

}
